<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);


// Incluir la conexión a la base de datos
include 'conn.php';

// Verificar la conexión
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
    exit();
}

// Obtener los parámetros enviados
$empresa = isset($_POST['empresa']) ? $_POST['empresa'] : null;
$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : null;
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : null;

if (!$empresa) {
    echo json_encode(['error' => 'Missing required parameter: empresa']);
    exit();
}

// Verificar si las fechas están presentes para decidir qué consulta realizar
if (!empty($start_date) && !empty($end_date)) {
    $query = "SELECT r.agencia, r.total AS monto, r.id, r.status AS estado, r.idr, r.service, r.arrival_date, r.arrival_time, 
                     r.arrival_hotel, r.departure_date, r.departure_pickuptime, r.departure_hotel, r.name, r.arrival_pickup, 
                     r.chofer, r.proveedor_id, r.folio, r.costo_proveedor, r.departure_destino, r.arrival_airline, r.arrival_flight,
                     r.departure_airline, r.departure_flight, r.agencia, r.car, r.obs, r.obs_int, r.pax, p.empresa AS proveedor_nombre
              FROM reservas r
              LEFT JOIN proveedores p ON r.proveedor_id = p.id
              WHERE r.agencia = ?
              AND (r.arrival_date BETWEEN ? AND ? OR r.departure_date BETWEEN ? AND ?)
              AND r.status <> 4
              ORDER BY r.arrival_date, r.departure_date";

    $stmt = $conn->prepare($query);
    $stmt->bind_param('sssss', $empresa, $start_date, $end_date, $start_date, $end_date);
} else {
    $query = "SELECT t.id, t.fecha_transaccion, t.monto, t.estado
              FROM transacciones_proveedores t
              WHERE t.proveedor_id = ?";

    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $empresa);
}

$stmt->execute();
$result = $stmt->get_result();

// Obtener la fecha actual
$fecha_actual = date('Y-m-d');

$data = [];
while ($row = $result->fetch_assoc()) {
    $service_type = $row["service"];
    $proveedor_nombre = $row["proveedor_nombre"];
    $chofer = $row["chofer"];
    $tarifa = $row["monto"];
    $costo_proveedor = $row["costo_proveedor"];
    $utilidad = $tarifa - $costo_proveedor;
    $arrivalAirline = $row["arrival_airline"].' '.$row["arrival_flight"];
    $departureAirline = $row["departure_airline"].' '.$row["departure_flight"];


    
    if ($service_type == "ona") {
       
        $fecha_transaccion = $row["arrival_date"];
        $hotel = $row["arrival_hotel"];
        $data[] = [
            'id' => $row["id"],
            'estado' => $row["estado"],
            'fecha_servicio' => $fecha_transaccion,
            'monto' => $tarifa,
            'proveedor' => $proveedor_nombre,
            'chofer' => $chofer,
            'folio' => $row["folio"],
            'utilidad' => $utilidad,
            'costo_proveedor' => $costo_proveedor,
            'cliente' => $row["name"],         
            'hora' => $row["arrival_time"],
            'servicio' => 'Llegada',
            'pickup' => $row["arrival_pickup"],
            'destino' => $hotel,
            'airline' => $arrivalAirline,
            'idr' => $row["idr"],
            'agencia' => $row["agencia"],
            'car' => $row["car"],
            'obs' => $row["obs"],
            'obs_int' => $row["obs_int"],
            'pax' => $row["pax"],
        ];
    } elseif ($service_type == "ond") {
        
        $fecha_transaccion = $row["departure_date"];
        $data[] = [
            'id' => $row["id"],
            'estado' => $row["estado"],
            'fecha_servicio' => $fecha_transaccion,
            'monto' => $row["monto"],
            'proveedor' => $proveedor_nombre,
            'chofer' => $chofer,
            'folio' => $row["folio"],
            'utilidad' => $utilidad,
            'costo_proveedor' => $costo_proveedor,
            'cliente' => $row["name"],
            'hora' => $row["departure_pickuptime"],
            'servicio' => 'Salida',
            'pickup' => $row["departure_hotel"],
            'destino' => $row["departure_destino"],
            'airline' => $departureAirline,
            'idr' => $row["idr"],
            'agencia' => $row["agencia"],
            'car' => $row["car"],
            'obs' => $row["obs"],
            'obs_int' => $row["obs_int"],
            'pax' => $row["pax"],
        ];
    } elseif ($service_type == "roa") {
        // Dividir el monto entre 2 para cada parte del viaje
        $monto_dividido = $row["monto"] / 2;

        $utilidad_dividida = $utilidad / 2;

        // Servicio de llegada - Mostrar siempre el estado de la llegada
        
        $fecha_transaccion_llegada = $row["arrival_date"];
        
        $data[] = [
            'id' => $row["id"],
            'estado' => $row["estado"],
            'fecha_servicio' => $fecha_transaccion_llegada,
            'monto' => $monto_dividido,
            'proveedor' => $proveedor_nombre,
            'chofer' => $chofer,
            'folio' => $row["folio"],
            'utilidad' => $utilidad_dividida,
            'costo_proveedor' => $costo_proveedor,
            'cliente' => $row["name"],
            'destino' => $row["arrival_hotel"],
            'hora' => $row["arrival_time"],
            'servicio' => 'Llegada',
            'pickup' => $row["arrival_pickup"],
            'airline' => $arrivalAirline,
            'idr' => $row["idr"],
            'agencia' => $row["agencia"],
            'car' => $row["car"],
            'obs' => $row["obs"],
            'obs_int' => $row["obs_int"],
            'pax' => $row["pax"],

        ];

        // Servicio de salida - Mostrar como "pendiente" si la fecha de salida es futura
       
        $fecha_transaccion_salida = $row["departure_date"];
        
        // Determinar el estado de la salida basado en la fecha
        $estado_salida = ($row["departure_date"] > $fecha_actual) ? 'Pendiente' : $row["estado"];

        $data[] = [
            'id' => $row["id"],
            'estado' => $estado_salida,
            'fecha_servicio' => $fecha_transaccion_salida,
            'monto' => $monto_dividido,
            'proveedor' => $proveedor_nombre,
            'chofer' => $chofer,
            'folio' => $row["folio"],
            'utilidad' => $utilidad_dividida,
            'costo_proveedor' => $costo_proveedor,
            'cliente' => $row["name"],
            'destino' => $row["departure_hotel"],
            'hora' => $row["departure_pickuptime"],
            'servicio' => 'Salida',
            'pickup' => $row["departure_hotel"],
            'airline' => $departureAirline,
            'idr' => $row["idr"],
            'agencia' => $row["agencia"],
            'car' => $row["car"],
            'obs' => $row["obs"],
            'obs_int' => $row["obs_int"],
            'pax' => $row["pax"],

            
        ];

    } elseif ($service_type == "tra") {
       
        $fecha_transaccion = $row["arrival_date"];
        $data[] = [
            'id' => $row["id"],
            'estado' => $row["estado"],
            'fecha_servicio' => $fecha_transaccion,
            'monto' => $row["monto"],
            'proveedor' => $proveedor_nombre,
            'chofer' => $chofer,
            'folio' => $row["folio"],
            'utilidad' => $utilidad,
            'costo_proveedor' => $costo_proveedor,
            'cliente' => $row["name"],
            'destino' => $row["arrival_hotel"],
            'hora' => $row["arrival_time"],
            'servicio' => 'Traslado',
            'pickup' => $row["arrival_pickup"],
            'airline' => 'N/A',
            'idr' => $row["idr"],
            'agencia' => $row["agencia"],
            'car' => $row["car"],
            'obs' => $row["obs"],
            'obs_int' => $row["obs_int"],
            'pax' => $row["pax"],


        ];
    } elseif ($service_type == "trr") {
        // Dividir el monto entre 2 para cada parte del viaje
        $monto_dividido = $row["monto"] / 2;

        // Servicio de traslado de ida - Mostrar siempre el estado de la llegada
       
        $fecha_transaccion = $row["arrival_date"];


        $data[] = [
            'id' => $row["id"],
            'estado' => $row["estado"],
            'fecha_servicio' => $fecha_transaccion,
            'monto' => $row["monto"],
            'proveedor' => $proveedor_nombre,
            'chofer' => $chofer,
            'folio' => $row["folio"],
            'utilidad' => $utilidad,
            'costo_proveedor' => $costo_proveedor,
            'cliente' => $row["name"],
            'destino' => $row["arrival_hotel"],
            'hora' => $row["arrival_time"],
            'servicio' => 'Traslado',
            'pickup' => $row["arrival_pickup"],
            'airline' => 'N/A',
            'idr' => $row["idr"],
            'agencia' => $row["agencia"],
            'car' => $row["car"],
            'obs' => $row["obs"],
            'obs_int' => $row["obs_int"],
            'pax' => $row["pax"],
        ];

        

    } elseif ($service_type == "ope") {
        //$descripcion = 'Open Service: ' . $row["arrival_pickup"] . ' Fecha: ' . $row["arrival_date"] . ' Hora: ' . $row["arrival_time"] . ' Cliente: ' . $row["name"] . '<a href="https://deserttravelplus.com/btec_v1/my-reservation.php?idr=' . $row["idr"] . '&ida=DESER&back=0&url=servicios&admin=1&action=no" target="_blank"> Ver Reserva</a>';
        $fecha_transaccion = $row["arrival_date"];
        $data[] = [
            'id' => $row["id"],
            'estado' => $row["estado"],
            'fecha_servicio' => $fecha_transaccion,
            'monto' => $row["monto"],
            'proveedor' => $proveedor_nombre,
            'chofer' => $chofer,
            'folio' => $row["folio"],
            'utilidad' => $utilidad,
            'costo_proveedor' => $costo_proveedor,
            'cliente' => $row["name"],
            'destino' => $row["arrival_hotel"],
            'hora' => $row["arrival_time"],
            'servicio' => 'Open Service',
            'pickup' => $row["arrival_pickup"],
            'airline' => 'N/A',
            'idr' => $row["idr"],
            'agencia' => $row["agencia"],
            'car' => $row["car"],
            'obs' => $row["obs"],
            'obs_int' => $row["obs_int"],
            'pax' => $row["pax"],
            
        ];
    }
}

// Convertir los datos a JSON y devolverlos
echo json_encode($data);

$conn->close();


?>

