<?php
header('Content-Type: application/json');

// Incluir la conexión a la base de datos
include 'conn.php';

// Verificar la conexión
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
    exit();
}

// Obtener el cuerpo de la solicitud y decodificar el JSON
$input = json_decode(file_get_contents('php://input'), true);

// Obtener las fechas del input
$start_date = isset($input['start_date']) ? $input['start_date'] : null;
$end_date = isset($input['end_date']) ? $input['end_date'] : null;

if ($start_date && $end_date) {
    // Realizar la consulta para agrupar por agencia y contar los registros, considerando "roa" como doble
    $query2 = "SELECT agencia, 
                      SUM(CASE WHEN service = 'roa' THEN 2 ELSE 1 END) AS num_registros, 
                      SUM(total) AS total_suma
               FROM reservas
               WHERE (arrival_date BETWEEN ? AND ? OR departure_date BETWEEN ? AND ?)
               AND status <> 4
               GROUP BY agencia";

    $stmt2 = $conn->prepare($query2);
    $stmt2->bind_param('ssss', $start_date, $end_date, $start_date, $end_date);
    $stmt2->execute();
    $result2 = $stmt2->get_result();

    $data = [];
    if ($result2->num_rows > 0) {
        while ($row = $result2->fetch_assoc()) {
            $data[] = $row;
        }
    }

    // Convertir los datos a JSON y devolverlos
    echo json_encode(['reservas' => $data]);
} else {
    echo json_encode(['error' => 'Invalid or missing date range']);
}


$conn->close();
?>


